unit LottoU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls;

type
TLottoFrm = class(TForm)
    SzelvenyBtn: TButton;
    KilepBtn: TButton;
    procedure FormCreate(Sender: TObject);
    procedure BLottoClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SzelvenyBtnClick(Sender: TObject);
    procedure KilepBtnClick(Sender: TObject);
  private
    BLotto : array[0..5,0..14] of TButton;
    db : byte;
    procedure Torol;
  end;

var
  LottoFrm: TLottoFrm;

implementation

{$R *.DFM}

{ Az sszes nyomgomb kzs esemnykezel eljrsa }
procedure TLottoFrm.BLottoClick(Sender: TObject);
begin
    with (Sender as TButton) do
       if tag=1 then  // kivlasztott volt
         begin
           Font.Size:=10;
           tag:=0;
           dec(db);
         end
        else         // nem volt kivlasztva
         begin;
           if db>=5 then
             begin
              beep;
              exit;
             end;
           Font.Size:=16;
           tag:=1;
           LottoFrm.ActiveControl:=nil;
           inc(db);
         end;
end;

{ A form ltrehozsakor helyezzk fel a formra a
  90 lottgombot s belltjuk a tulajdosgaikat.}
procedure TLottoFrm.FormCreate(Sender: TObject);
var
  i,j : integer;
begin
   for i:=0 to 5 do
     for j:=0 to 14 do
      begin
         BLotto[i,j]:=TButton.Create(LottoFrm);
         with BLotto[i,j] do
           begin
              // a szlablak
              parent:=LottoFrm;
              // a gomb szmtott helye
              width:=26;
              height:=24;
              left:=LottoFrm.clientwidth div 2  - (8-j)* (width+3) + 16;
              top:=LottoFrm.clientheight div 2  - (3-i)* (height+2) +12 ;
              // a gomb feliratnak megadsa
              Caption:=inttostr(i*15+j+1);
              // a gomb esemnykezlje
              OnClick:=BLottoClick;
           end;
      end;
   // a fontmret belltsa 10 pontra,
   // s Tag tulajdonsg nullzsa
   Torol;
end;

{ Az ablak lezrsakor gondoskodunk a gombok megszntetsrl }
procedure TLottoFrm.FormClose(Sender: TObject; var Action: TCloseAction);
var
  i,j : integer;
begin
   for i:=0 to 5 do
     for j:=0 to 14 do
         if Assigned(BLotto[i,j]) then BLotto[i,j].Free;
end;

{ A gombokat kiindulsi llapotba lltjuk}
procedure TLottoFrm.Torol;
var
  i,j : integer;
begin
   for i:=0 to 5 do
     for j:=0 to 14 do
         with BLotto[i,j] do
          begin
            tag:=0;
            Font.Size:=10;
          end;
end;

{ j szelvny kitltse eltt elvgezzk a szksges inicializcis
  lpseket }
procedure TLottoFrm.SzelvenyBtnClick(Sender: TObject);
begin
  Torol;
  db:=0;
end;

procedure TLottoFrm.KilepBtnClick(Sender: TObject);
begin
  Close;
end;

end.
